//=============================================================================
// WorkBenchMenuMain
//=============================================================================

class WorkBenchMenuCraftAccesories expands MenuUIWindow;

//Universals
var DeusExPlayer Player;
var PartsBag Bench;
var MSMassEffectMutator Mutator;

//Window Specifics
var MenuUIActionButtonWindow exitButton;
var localized string exitButtonText;

var ColorButtonForward NextPart;
var ColorButtonBackward PrevPart;

var class<CraftingPart> CurPart;

var Window PartDisplay, ScrapDisplay;

var ModifiedPersonaTextWindow Durability, Price;

var ModifiedPersonaTextWindow  StatDisplay, ScrapText;
var MenuUIEditWindow CustomNameField;

var int CurPartNum, MaxPartNum;
var class<CraftingPart> PartIndex[50];
var int YOffs[50];
var int XOffs[50];
var int XSize[50];
var int YSize[50];

var PersonaActionButtonWindow CreateButton;

var Window Last;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window... it's way down there...
// In the meantime, here's a lot of precautionary vomit!
// ----------------------------------------------------------------------


function bool CanPushScreen(Class <DeusExBaseWindow> newScreen)
{
 return false;
}

function bool CanStack()
{
 return false;
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
 return false;
}

event bool RawKeyPressed(EInputKey key, EInputState iState, bool bRepeat)
{
 return false;
}

event InitWindow()
{
 local int i, j;

	Super.InitWindow();
        SetTitle("Scrap To Part Conversion");
        exitButton = winButtonBar.AddButton(exitButtonText, HALIGN_Left);
	
	CreateOverlays();
	CreateButtons();
        CreateDurabilities();
	CreateTextDisplay();

	CustomNameField = CreateMenuEditWindow(347, 272, 132, 24, winClient);
	CustomNameField.SetText("");
}

function CreateTextDisplay()
{
 StatDisplay = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 StatDisplay.SetPos(16, 268);
 StatDisplay.SetSize(240, 96);
 StatDisplay.SetFont(Font'FontMenuHeaders');

 ScrapText = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 ScrapText.SetPos(96, 8);
 ScrapText.SetSize(96, 96);
 ScrapText.SetFont(Font'FontMenuHeaders');

 ScrapDisplay.SetBackground(Texture'ScrapMetalWB');
}

function CreateDurabilities()
{
 Durability = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Durability.SetPos(256, 128);
 Durability.SetSize(96, 20);
 Durability.SetFont(Font'FontMenuHeaders');

 Price = ModifiedPersonaTextWindow(NewChild(Class'ModifiedPersonaTextWindow'));
 Price.SetPos(256, 196);
 Price.SetSize(96, 20);
 Price.SetFont(Font'FontMenuHeaders');
}

function CreateButtons()
{
 	NextPart = ColorButtonForward(NewChild(Class'ColorButtonForward'));
	NextPart.SetPos(490, 288);

 	PrevPart = ColorButtonBackward(NewChild(Class'ColorButtonBackward'));
	PrevPart.SetPos(324, 288);
		
	CreateButton = PersonaActionButtonWindow(NewChild(Class'PersonaActionButtonWindow'));
	CreateButton.SetPos(448, 368);
	CreateButton.SetButtonText("|p4CREATE!");
}

function CreateOverlays()
{	
	PartDisplay = NewChild(Class'Window');
	SetupOverlay(PartDisplay, 0, 0, 256, 256);

	ScrapDisplay = NewChild(Class'Window');
	SetupOverlay(ScrapDisplay, 32, 32, 64, 64);
}

function SetupOverlay(Window Win, int PosX, int PosY, int WidthX, int HeightY)
{
	win.SetBackgroundStyle(DSTY_Masked);
	win.SetPos(PosX, PosY);
	win.SetSize(WidthX, HeightY);
}

function UpdateIcons()
{
 if (CurPart == None) PartDisplay.SetBackground(None);
 if (CurPart != None)
 {
  SetupOverlay(PartDisplay, XOffs[CurPartNum], YOffs[CurPartNum], XSize[CurPartNum], YSize[CurPartNum]);
  PartDisplay.SetBackground(CurPart.Default.BenchIcon);
 }
 
 UpdateStats();
}

function UpdateStats()
{
 //StatDisplay.SetText(TempSpawnStats()$CR()$"|p4Cost: "$CurPart.Default.Cost);
 StatDisplay.SetText(TempSpawnStats());
 
 if (CurPart != None)
 {
  Price.SetText("|p4Cost: "$CurPart.Default.Cost);
  Durability.SetText(CurPart.Default.Durability);
  CustomNameField.SetText(CurPart.Default.ItemName);
 }
 
 if (CurPart == None)
 {
  Price.SetText("");
  Durability.SetText("");
  CustomNameField.SetText("");
 }
 
 ScrapText.SetText(String(Mutator.CurScrap));
}

function String TempSpawnStats()
{
 local CraftingPart C;
 local String S;
 
 C = Bench.Spawn(CurPart,,,Bench.Location + vect(0,0,30));
 
 S = C.GetStats();
 
 C.Destroy();
 
 return S;
}

simulated function String FormatFloatString(float value, float precision)
{
	local string str;

	if (precision == 0.0)
		return "ERR";

	// build integer part
	str = String(Int(value));

	// build decimal part
	if (precision < 1.0)
	{
		value -= Int(value);
		str = str $ "." $ String(Int((0.5 * precision) + value * (1.0 / precision)));
	}

	return str;
}

function CreatePart()
{
 local CraftingPart C;
 
 if (CurPart == None || Mutator.CurScrap < CurPart.Default.Cost)
 {
  Bench.PlaySound(Sound'InsufficientScrap');
  return;
 }
 
 C = Bench.Spawn(CurPart,,,Bench.Location + vect(0,0,30));
 C.Frob(Player, None);
 
 Mutator.CurScrap -= CurPart.Default.Cost;
 
 Bench.PlaySound(Sound'PurchaseSuccess');
 
 UpdateIcons();
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local name TempName;

	bHandled = True;

	Super.ButtonActivated(buttonPressed);

	switch(buttonPressed)
	{
		case exitButton:

			Last.Show(True);

			//Ralph.ChargeTheGates(TempName);
			// Do stuff
			root.PopWindow();
			bHandled = True;
			break;

		case NextPart:
			CurPartNum++;
			if (CurPartNum > MaxPartNum) CurPartNum = 0;
			CurPart = PartIndex[CurPartNum];
			UpdateIcons();
			bHandled = True;
			break;
		case PrevPart:
			CurPartNum--;
			if (CurPartNum < 0) CurPartNum = MaxPartNum;
			CurPart = PartIndex[CurPartNum];
			UpdateIcons();
			bHandled = True;
			break;

		case CreateButton:
			CreatePart();
			bHandled = True;
			break;

		default:
			bHandled = False;
			break;
	}

	/*if (ButtonPressed != exitButton)
	{
		UpdateInfo();
	}*/

	return bHandled;
}

defaultproperties
{

     Title="Scrap to Part Conversion"
     exitButtonText="Done"
     ClientWidth=512
     ClientHeight=384

     clientTextures(0)=Texture'WorkBenchRifleBG1'
     clientTextures(1)=Texture'WorkBenchRifleBG2'
     clientTextures(2)=Texture'WorkBenchRifleBG3'
     clientTextures(3)=Texture'WorkBenchRifleBG4'

     bActionButtonBarActive=True
     bUsesHelpWindow=False
     ScreenType=ST_Persona
     TextureRows=2
     TextureCols=2
     exitButtonText="Cancel"
     MaxPartNum=4
     CurPartNum=0
     CurPart=Class'AcogSight'

     PartIndex(0)=class'AcogSight'
     YOffs(0)=100
     XOffs(0)=249
     XSize(0)=64
     YSize(0)=64
     PartIndex(1)=class'GrenadeLauncher'
     YOffs(1)=100
     XOffs(1)=249
     XSize(1)=64
     YSize(1)=64
     PartIndex(2)=class'LaserSight'
     YOffs(2)=100
     XOffs(2)=249
     XSize(2)=64
     YSize(2)=64
     PartIndex(3)=class'Silencer'
     YOffs(3)=100
     XOffs(3)=249
     XSize(3)=64
     YSize(3)=64
     PartIndex(4)=class'Flashlight'
     YOffs(4)=100
     XOffs(4)=249
     XSize(4)=64
     YSize(4)=64
}
